package com.google.code.ccr4j.extensions;

import com.google.code.ccr4j.ActorType.Address;

/**
 * Interface for the Address extensions to the CCR. Allows addresses to be fetched from an ActorType by name.
 * @author aeagle
 *
 */
public interface AddressHelper {
    public static final String WORK_ADDRESS = "Work";
    public static final String HOME_ADDRESS = "Home";
    /**
     * Get an Address from this ActorType of type HOME_ADDRESS
     * @return the address, or null if there isn't one
     */
    Address getHomeAddress();
    /**
     * Get an Address from this ActorType of type WORK_ADDRESS
     * @return the address, or null if there isn't one
     */
    Address getWorkAddress();
    /**
     * Set the address into this ActorType with type HOME_ADDRESS.
     * If there is already a HOME_ADDRESS, replace it with the given address
     * @param address
     */
    void setHomeAddress(Address address);
    /**
     * Set the address into this ActorType with type WORK_ADDRESS.
     * If there is already a WORK_ADDRESS, replace it with the given address
     * @param address
     */
    void setWorkAddress(Address address);
}
