package com.google.code.ccr4j.extensions;

import java.util.Arrays;
import java.util.List;

/**
 * Used by XMLBeans. 
 * This interface provides extensions to the CCR ActorType so that ID's such as SSN can be accessed directly.
 * @author aeagle
 *
 */
public interface IdentificationHelper {

    /**
     * String value written to the Type of the ID when setting a Social Security Number
     */
    public static final String SOCIAL_SECURITY_NUMBER = "SSN";
    /**
     * String value written to the Type of the ID when setting a Chart Number
     */
    public static final String CHART_NUMBER = "Chart Number";
    
    /**
     * Values in the Type of an ID that are considered when getting a Social Security Number
     */
    public static final List<String> SOCIAL_SECURITY_NUMBER_KEYS = Arrays.asList(new String[]{SOCIAL_SECURITY_NUMBER, "Social Security Number"});
    /**
     * Values in the Type of an ID that are considered when getting a Chart Number
     */
    public static final List<String> CHART_NUMBER_KEYS = Arrays.asList(new String[]{CHART_NUMBER});

    /**
     * Get the ID from this ActorType that has a Type matching an element in the SOCIAL_SECURITY_NUMBER_KEYS list.
     * @return the ID, or null if there isn't a match
     */
    public String getSocialSecurityNumber();
    /**
     * Get the ID from this ActorType that has a Type matching an element in the CHART_NUMBER_KEYS list.
     * @return the ID, or null if there isn't a match
     */
    public String getChartNumber();
    /**
     * Set the chartNumber as an IDType into this ActorType with type CHART_NUMBER.
     * If there is already a CHART_NUMBER, replace it with the given ID.
     * @param chartNumber
     */
    public void setChartNumber(String chartNumber);
    /**
     * Set the ssn as an IDType into this ActorType with type SOCIAL_SECURITY_NUMBER.
     * If there is already a SOCIAL_SECURITY_NUMBER, replace it with the given ID.
     * @param ssn
     */
    public void setSocialSecurityNumber(String ssn);
    

}
