package com.google.code.ccr4j.extensions;

/**
 * Interface for the Telephone extension to the CCR ActorType. Allows direct access to the actor's telephone numbers.
 * @author aeagle
 *
 */
public interface TelephoneHelper {
    public static final String WORK_PHONE = "Work";
    public static final String HOME_PHONE = "Home";
    /**
     * Get a phone number from this ActorType of type HOME_PHONE
     * @return the phone number, or null if there isn't one
     */
    String getHomePhone();
    /**
     * Get a phone number from this ActorType of type WORK_PHONE
     * @return the phone number, or null if there isn't one
     */
    String getWorkPhone();
    /**
     * Set the phone number into this ActorType with type HOME_PHONE.
     * If there is already a HOME_PHONE, replace it with the given phone number
     * @param phone
     */
    void setHomePhone(String phone);
    /**
     * Set the phone number into this ActorType with type WORK_PHONE.
     * If there is already a WORK_PHONE, replace it with the given phone number
     * @param phone
     */
    void setWorkPhone(String phone);
}
