package com.google.code.ccr4j;

import org.junit.Test;
import static org.junit.Assert.*;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * Tests for this funky date format
 *
 * @author aeagle
 */
public class ISO8601DateFormatTest {
	@Test
	public void testFormat() {
        DateFormat formatter = new ISO8601DateFormat();
        formatter.setTimeZone(TimeZone.getTimeZone("EST"));
        assertEquals("2007-03-14T13:00:00-05:00",
                formatter.format(new Date(1173895200000L)));
    }

    @Test
    public void testFormatZulu() {
        DateFormat formatter = new ISO8601DateFormat();
        formatter.setTimeZone(TimeZone.getTimeZone("Zulu"));
		assertEquals("2007-03-14T18:00:00Z", formatter.format(
						new Date(1173895200000L)));
	}

	@Test
	public void testParseZulu() throws ParseException {
        DateFormat formatter = new ISO8601DateFormat();
        Date expected = new Date(1173895200000L);
        assertEquals(expected, formatter.parse("2007-03-14T18:00:00Z"));
    }

    @Test
	public void testParse() throws ParseException {
        DateFormat formatter = new ISO8601DateFormat();
        Date expected = new Date(1173895200000L);
        assertEquals(expected, formatter.parse("2007-03-14T14:00:00-04:00"));
	}
}
