package oh.how.easy.fck.resolvers;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import net.fckeditor.localization.LocaleResolver;
import oh.how.easy.fck.services.FckEditorLocaleService;
import oh.how.easy.fck.util.LegacyT5ServiceHelper;
import org.apache.tapestry5.ioc.services.ThreadLocale;

/**
 * This implementation passes locale data to Fck editor java integration lib.
 * @author Ville Virtanen
 */
public class FckEditorLanguageResolver implements LocaleResolver {

    /**
     * @param request
     * @return The locale provided by the {@link FckEditorLocaleService}. If this service is not found or the service returns null, then returns the Tapestry 5 locale.
     */
    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        FckEditorLocaleService localeService = LegacyT5ServiceHelper.getService(FckEditorLocaleService.class, request);
        if(localeService == null || localeService.getLocale() == null) {
            ThreadLocale pl = LegacyT5ServiceHelper.getService(ThreadLocale.class, request);
            Locale locale = pl.getLocale();
            return locale;
        }
        return localeService.getLocale();
    }

}
