package oh.how.easy.fck.resolvers;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.requestcycle.UserPathBuilder;
import oh.how.easy.fck.services.FckEditorPathService;
import oh.how.easy.fck.util.LegacyT5ServiceHelper;

/**
 * The implementation that passes path data to Fck editor java integration lib.
 * @author Ville Virtanen
 */
public class FckEditorPathResolver implements UserPathBuilder {

    @Override
    public String getUserFilesAbsolutePath(HttpServletRequest request) {
        FckEditorPathService editorService = LegacyT5ServiceHelper.getService(FckEditorPathService.class, request);
        if(editorService == null) {
            return "";
        }
        return editorService.getServerPathForFiles();
    }

    @Override
    public String getUserFilesPath(HttpServletRequest request) {
        FckEditorPathService editorService = LegacyT5ServiceHelper.getService(FckEditorPathService.class, request);
        if(editorService == null) {
            return "";
        }
        return editorService.getClientURLStartForFiles();
    }

}
