package oh.how.easy.fck.resolvers;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.requestcycle.UserAction;
import oh.how.easy.fck.services.FckEditorUserRightService;
import oh.how.easy.fck.util.LegacyT5ServiceHelper;

/**
 * The implementation that passes user rights data to Fck editor java integration lib.
 * @author Ville Virtanen
 */
public class FckEditorUserRightsResolver implements UserAction {

    /**
     * Whether user is allowed to create new folders below the given root path. <br />
     * Defaults to false if there is no implementation of FckEditorUserRightService.
     * @param request
     * @return
     */
    @Override
    public boolean isCreateFolderEnabled(HttpServletRequest request) {
        FckEditorUserRightService editorService = LegacyT5ServiceHelper.getService(FckEditorUserRightService.class, request);
        if(editorService == null) {
            return false;
        }
        return editorService.canCreateFolders();
    }

    /**
     * Whether user is allowed to browse existing directory structure and files. <br />
     * Defaults to false if there is no implementation of FckEditorUserRightService.
     * @param request
     * @return
     */
    @Override
    public boolean isEnabledForFileBrowsing(HttpServletRequest request) {
        FckEditorUserRightService editorService = LegacyT5ServiceHelper.getService(FckEditorUserRightService.class, request);
        if(editorService == null) {
            return false;
        }
        return editorService.canBrowseFiles();
    }

    /**
     * Whether user is allowed to upload files to existing directories. <br />
     * Defaults to false if there is no implementation of FckEditorUserRightService.
     * @param request
     * @return
     */
    @Override
    public boolean isEnabledForFileUpload(HttpServletRequest request) {
        FckEditorUserRightService editorService = LegacyT5ServiceHelper.getService(FckEditorUserRightService.class, request);
        if(editorService == null) {
            return false;
        }
        return editorService.canUploadFiles();
    }
    
}