package oh.how.easy.fck.services;

import org.apache.tapestry5.Asset;

/**
 *
 * @author Ville Virtanen
 */
public interface FckEditorService {

    /**
     * Saves configuration so that during subsequent requests we don't have to
     * process it again.
     * @param asset
     * @param configurationKey
     * @param containingPage
     */
    public void persistEditorConfiguration(Asset asset);

    /**
     * Saves configuration so that during subsequent requests we don't have to process it again.
     * Also adds the FCKConfig.SkinPath variable to given value prepended with the current context.
     * @param asset
     * @param skinConfiguration
     */
    public void persistEditorConfiguration(Asset asset, String skinConfiguration);

    /**
     * Returns the key which can be used to fetch the configuration later using method getEditorConfiguration that was added with method persistEditorConfiguration.
     * @param asset
     * @return
     */
    public String getEditorConfigurationKey(Asset asset);

    /**
     * Returns earlier saved configuration or empty string if none found.
     * @param configurationKey
     * @return
     */
    public String getEditorConfiguration(String configurationKey);

}
