package oh.how.easy.fck.services;

/**
 * This interface represents the service that must be implemented when using file uploads. <br />
 * This service tells Fck editor what current user is allowed to do.
 * @author Ville Virtanen
 */
public interface FckEditorUserRightService {

    /**
     * Whether user is allowed to create new folders below the given root path.
     * @return
     */
    public boolean canCreateFolders();

    /**
     * Whether user is allowed to browse existing directory structure and files.
     * @return
     */
    public boolean canBrowseFiles();

    /**
     * Whether user is allowed to upload files to existing directories.
     * @return
     */
    public boolean canUploadFiles();

}
