package problems;

import utils.Utils;

public class Problem72 extends Problem<Long> {

	private static final int LIMIT = 1000000;

	public static void main(String[] args) {
		Problem72 problem72 = new Problem72();
		problem72.runTimed();
		problem72.printResult();
	}
	
	@Override
	public void run() {
		//Run time 3 hours :(
		long startTime = System.currentTimeMillis();
		long amount = 2*LIMIT - 3;

		for (int d = 1; d <= LIMIT; d++) {
			for (int n = 2; n < d; n++) {
				if (d % n != 0 && d % (d-n) != 0) {
					amount++;
				}
			}
			
			if (d % 10000 == 0) {
				Utils.printProgress(d, LIMIT, startTime);
			}
			
			if (amount < 0) {
				throw new IllegalStateException("Overflow");
			}
		}
		
		setResult(amount);
	}
}
