package problems;

import utils.Utils;

public class Problem75 {
	private static final int LIMIT = 1500000;

	// O(n^3)  :(
	public static void main(String[] args) {
		long startTime = System.currentTimeMillis();
		int result = 0;
		for (int length = 12; length <= LIMIT; length++) {
			if (check(length)) {
//				System.out.println("found " + length);
				result++;
			}
			if (length % 1000 == 0) {
				Utils.printProgress(length, LIMIT, startTime);
			}
		}
		System.out.println(result);
	}

	private static boolean check(int length) {
		boolean result = false;
		for (int longSide = 2; longSide < length/2; longSide++) {
			for (int a = 3; a < longSide; a+=3) {
				int b = length - longSide - a;
				if (b >= longSide || b%4 != 0) {// || b < a) {
					continue;
				}
				if (!(a % 5 == 0 || b % 5 == 0 || longSide % 5 == 0)) {
					continue;
				}
				if (Utils.isTriangle(a, b, longSide)) {
//					System.out.printf("%d: %d, %d, %d%n", length, a, b, longSide);
					if (result) {
						return false; //found second one
					}
					result = true;
				}
			}
		}
		return result;
	}
}
