package problems.runner;

import java.io.PrintStream;

public class ProblemThread extends Thread {
	private final Class<?> clazz;
	private final PrintStream out;
	private final int number;

	public ProblemThread(int number, PrintStream out) throws ClassNotFoundException {
		this.number = number;
		this.out = out;
		this.clazz = Class.forName("problems.Problem" + number);
	}
	
	@Override
	public void run() {
		long start = System.currentTimeMillis();
		try {
			clazz.getMethod("main", String[].class).invoke(null, new Object[]{new String[0]});
		} catch (Exception e) {
			e.printStackTrace(out);
		}
		out.printf("Execution for problem %3d took %4d ms%n", number, System.currentTimeMillis() - start);
	}
	
	@Override
	public String toString() {
		return getClass().getSimpleName() + number;
	}
}
