package problems.solved;

import java.util.Scanner;
import java.util.TreeSet;

import problems.Problem;
import utils.CountingIterator;
import utils.Utils;

public class Problem22 extends Problem<Integer> {
	public static void main(String[] args) {
		Problem22 problem22 = new Problem22();
		problem22.runTimed();
		problem22.printResult();
	}

	@Override
	public void run() {
		TreeSet<String> set = new TreeSet<String>();
		
		Scanner scanner = Utils.getScannerForFile("names.txt");
		scanner.useDelimiter(",");
		
		while (scanner.hasNext()) {
			final String quotedName = scanner.next();
			set.add(quotedName.substring(1, quotedName.length() - 1));
		}
		
		int sum = 0;
		CountingIterator<String> iterator = new CountingIterator<String>(set);
		while(iterator.hasNext()) {
			String name = iterator.next();
			sum += Utils.sumForUppercaseChars(name) * iterator.getCount();
		}
		setResult(sum);
	}
}
