package problems.solved;
import java.util.ArrayList;
import java.util.List;

import utils.Utils;


public class Problem23 {
	private static final int UPPER_LIMIT = 28123;

	public static void main(String[] args) {
		List<Integer> abundant = new ArrayList<Integer>();
		
		for (int i = 12; i <= UPPER_LIMIT; i++) {
			if (isAbundant(i)) {
				abundant.add(i);
			}
		}
		
		int sum = 0;
		o: for (int i = 0; i < UPPER_LIMIT; i++) {
			if (i % 1000 == 0) {
				Utils.printProgress(i+1, UPPER_LIMIT);
			}
			int limit = i/2;
			for (int n : abundant) {
				if (abundant.contains(i - n)) {
					continue o;
				}
				if (n > limit) {
					sum += i;
					continue o;
				}
			}
		}
		
		System.out.println("Sum of numbers that can't be written as the sum of two abundant numbers = " + sum); // 4179871
	}

	private static boolean isAbundant(int i) {
		return Utils.sumOfIntegers(Utils.divisors(i)) > i;
	}
}
