package problems.solved;

import java.util.List;

import problems.Problem;

import utils.Utils;

public class Problem27 extends Problem<Integer> {
	private static final List<Integer> bValues = Utils.sieve(1000); // n == 0 yields b ==> b needs to be prime.
	
	public static void main(String[] args) {
		Problem27 problem27 = new Problem27();
		problem27.runTimed();
		problem27.printResult();
	}

	@Override
	public void run() {
		int max = 0;
		int result = 0;
		
		for (int a = -999; a < 1000; a++) {
			for (int b : bValues) {
				int n = 0;
				int count = 0;
				
				int prime = n * n + a * n + b;
				while(prime > 0 && Utils.isPrimeCached(prime)) {
					count++;
					n++;
					prime = n * n + a * n + b;
				}
				if (count > max) {
					max = count;
					result = a*b;
				}
			}
		}
		setResult(result); // -59231
	}
}
