package problems.solved;

import java.util.Arrays;
import java.util.List;

import problems.Problem;

public class Problem31 extends Problem<Integer> {

	public static void main(String[] args) {
		Problem31 problem31 = new Problem31();
		problem31.runTimed();
		problem31.printResult();
	}
	
	
	@Override
	public void run() {
//		List<Integer> coins = Arrays.asList(1, 2, 5, 10, 20, 50, 100, 200);
		List<Integer> coins = Arrays.asList(200, 100, 50, 20, 10, 5, 2, 1); // about 4x as fast
		
		setResult(ways(200, coins)); // 73682
	}

	private int ways(int amountLeft, List<Integer> coins) {
		if (amountLeft == 0) {
			return 1;
		}
		int sum = 0;
		for (int i = 0; i < coins.size(); i++) {
			int coin = coins.get(i);
			if (coin <= amountLeft) {
				sum += ways(amountLeft - coin, coins.subList(i, coins.size()));
			}
		}
		return sum;
	}
}
