package problems.solved;

import problems.Problem;
import utils.Utils;


public class Problem34 extends Problem<Integer> {
	private static final int TARGET = 41000;
	private static final int[] factorials = {1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880};

	public static void main(String[] args) {
		Problem34 problem34 = new Problem34();
		problem34.runTimed();
		problem34.printResult();
	}
	
	@Override
	public void run() {
		int sum = 0;
		int mod = TARGET/100;
		for (int i = 10; i < TARGET; i++) {
			if (i % mod == 0) {
				Utils.printProgress(i, TARGET);
			}
			if (applies(i)) {
				System.out.println("Adding " + i);
				sum += i;
			}
		}
		setResult(sum);
	}

	private static boolean applies(int i) {
		int sum = 0;
		
		for (int n : Utils.numberIterable(i)) {
			sum += factorials[n];
		}
//		System.out.printf("Sum for %d (%s) is %d%n", i, n, sum);
		return sum == i;
	}
}
