package problems.solved;

import java.util.HashSet;
import java.util.Set;

import utils.Utils;

public class Problem35 {
	private static final int TARGET = 1000000;
	
	public static void main(String[] args) {
		int count = 1; //2
		for (int i = 3; i < TARGET; i+= 2) {
			if (isCircularPrime(i)) {
				count++;
			}
		}
		System.out.println(count); // 55
	}

	private static boolean isCircularPrime(int number) {
		final Set<Integer> rotated = rotate(number);
		for (int n : rotated) {
			if (!Utils.isPrimeCached(n)) {
				return false;
			}
		}
		return true;
	}

	private static Set<Integer> rotate(int number) {
		Set<Integer> set = rotate(""+number);
		return set;
	}

	private static Set<Integer> rotate(String text) {
		Set<Integer> set = new HashSet<Integer>();
		for (int i = 0; i < text.length(); i++) {
			set.add(Integer.valueOf(text.substring(i) + text.substring(0, i)));
		}
		return set;
	}
}
