package utils;

import java.util.Iterator;

public class CountingIterator<T> implements Iterator<T> {
	private final Iterator<T> iterator;
	private int count = 0;

	public CountingIterator(Iterator<T> iterator) {
		this.iterator = iterator;
	}

	public CountingIterator(Iterable<T> iterable) {
		this(iterable.iterator());
	}
	
	@Override
	public boolean hasNext() {
		return iterator.hasNext();
	}

	@Override
	public T next() {
		count++;
		return iterator.next();
	}

	@Override
	public void remove() {
		iterator.remove();
	}
	
	public int getCount() {
		return count;
	}
}
