package utils;

import java.util.Iterator;

public class PrimeIterator implements Iterator<Long> {
	long value = 2;
	
	@Override
	public boolean hasNext() {
		return true;
	}

	@Override
	public Long next() {
		if (value < 0) {
			throw new IllegalStateException("Overflow!");
		}
		long yield = value; 
		value = nextPrime(value);
		return yield;
	}

	private long nextPrime(long value) {
		if (value == 2) {
			return 3;
		}
		while(true) {
			value += 2;
			if (Utils.isPrime(value)) {
				return value;
			}
		}
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}
}
