package utils;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;

import org.junit.Ignore;
import org.junit.Test;

public class SieveTest {
	@Test
	public void testLowValues() {
		assertEquals("[2, 3]", Utils.sieve(4).toString()); //Yea, I'm lazy
		assertEquals("[2, 3, 5, 7, 11, 13, 17, 19]", Utils.sieve(20).toString());
	}
	
	@Test @Ignore("takes too long")
	public void testUpTo() {
		final int amount = 100000;
		for (int i = 2; i < amount; i++) {
			if (i % 1000 == 0) {
				Utils.printProgress(i, amount);
			}
			testSieveToLimit(i);
		}
	}

	private void testSieveToLimit(int limit) {
		List<Integer> fail = new ArrayList<Integer>();

		for (int prime : Utils.sieve(limit)) {
			if (!(Utils.isPrime(prime))) {
				fail.add(prime);
			}
		}

		if (!fail.isEmpty()) {
			fail("Sieve contained incorrect primes: " + fail);
		}
	}
}
