package org.exhibitj.automation.actions;

import org.exhibitj.automation.Action;
import org.exhibitj.automation.Agent;

public class ActionSequence implements Action {

	private final Action[] actions;

	public ActionSequence(Action...actions) {
		this.actions = actions;
	}

	@Override
	public void perform(Agent agent) {
		for (Action each : actions) {
			each.perform(agent);
		}
	}

}
