package org.exhibitj.automation.actions;

import org.exhibitj.automation.Action;
import org.exhibitj.automation.agents.RobotAgent;

public class AgentRunner implements Runnable{
	
	private final Action[] actions;
	private RobotAgent withAgent;

	public AgentRunner(Action[] actions) {
		this.actions = actions;
		withAgent = new RobotAgent();
	}
	
	@Override
	public void run() {
		for (Action request : actions) {
			request.perform(withAgent);
		}
	}

}
