package org.exhibitj.operators;

import java.util.logging.Logger;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.exhibitj.operators.matchers.Matcher;

public class ButtonOperator extends AbstractTextOperator {
	private static final Logger LOG = Logger.getLogger(ButtonOperator.class.getSimpleName());
	private Button button;

	public ButtonOperator(ShellOperator shell, Matcher<Button>...matching) {
		super(shell);
		button = shell.findWidget(Button.class, matching);
	}

	@Override
	protected Control getControl() {
		return button;
	}

	@Override
	protected FetchingRunnable<String> textDisplayFetcher() {
		return new FetchingRunnable<String>() {
			@Override
			public String fetchValue() {
				LOG.info("text on button");
				return button.getText();
			}
		};
	}
}
