package org.exhibitj.operators.matchers;

import org.eclipse.swt.widgets.Button;

public class ButtonTextMatcher implements Matcher<Button> {
	private final String desiredText;

	public ButtonTextMatcher(String textOnWidget) {
		this.desiredText = textOnWidget;
	}

	@Override
	public boolean isMatch(Button control) {
		return desiredText.equals(control.getText());
	}
	
	@Override
	public String describe(Button control) {
		return "expected to have text [" + desiredText + "] but instead had [" + control.getText() + "]";
	}
}
