package org.exhibitj.operators.matchers;


/**
 * Used to specify what index the control is to be found
 * @author greg
 *
 */
public class IndexMatcher<T> implements Matcher<T> {
	private final int index;
	int count = 0;

	public IndexMatcher(int index) {
		this.index = index;
	}

	@Override
	public boolean isMatch(T value) {
		count++;
		return count == index;
	}

	@Override
	public String describe(T value) {
		return "Only found " + count + " [Text] widgets,\nlooking for+ [" + index + "]";
	}
}