package org.exhibitj.operators.matchers;

import org.eclipse.swt.widgets.Control;

public class NamedControlMatcher<T extends Control> implements Matcher<T> {
	public static final String DEFAULT_NAME = "NAME";
	private final String keyName;
	private final Object nameValue;
	
	public NamedControlMatcher(Object nameValue) {
		this(DEFAULT_NAME, nameValue);
	}
	
	public NamedControlMatcher(String keyName, Object nameValue) {
		this.keyName = keyName;
		this.nameValue = nameValue;
		;
	}

	@Override
	public boolean isMatch(T value) {
		return nameValue.equals(value.getData(keyName));
	}

	@Override
	public String describe(T value) {
		return "with data [key:" + keyName + ", value:" + nameValue + "]";
	}

}
