package org.exhibitj.calculator;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.exhibitj.operators.ButtonOperator;
import org.exhibitj.operators.ShellOperator;
import org.exhibitj.operators.TextOperator;
import org.exhibitj.operators.UIBuilder;
import org.exhibitj.operators.matchers.ButtonTextMatcher;
import org.exhibitj.operators.matchers.EqualityMatcher;
import org.exhibitj.operators.matchers.IndexMatcher;
import org.junit.Test;

public class TestCalculator {

	@Test
	public void test() throws Exception {
		ShellOperator shell = new ShellOperator(new UIBuilder() {
			
			@Override
			public void create(Shell shell) {
				new Calculator(shell).open();
			}
		});
		shell.open();
		
		try {
			TextOperator result = new TextOperator(shell, new IndexMatcher<Text>(1));
			
			ButtonOperator nine = new ButtonOperator(shell, new ButtonTextMatcher("9"));
			ButtonOperator eight = new ButtonOperator(shell, new ButtonTextMatcher("8"));
			ButtonOperator seven = new ButtonOperator(shell, new ButtonTextMatcher("7"));
			ButtonOperator six = new ButtonOperator(shell, new ButtonTextMatcher("6"));
			ButtonOperator five = new ButtonOperator(shell, new ButtonTextMatcher("5"));
			ButtonOperator four = new ButtonOperator(shell, new ButtonTextMatcher("4"));
			ButtonOperator three = new ButtonOperator(shell, new ButtonTextMatcher("3"));
			ButtonOperator two = new ButtonOperator(shell, new ButtonTextMatcher("2"));
			ButtonOperator one = new ButtonOperator(shell, new ButtonTextMatcher("1"));
			ButtonOperator zero = new ButtonOperator(shell, new ButtonTextMatcher("0"));
			
			ButtonOperator plus = new ButtonOperator(shell, new ButtonTextMatcher("+"));
			ButtonOperator minus = new ButtonOperator(shell, new ButtonTextMatcher("-"));
			ButtonOperator divide = new ButtonOperator(shell, new ButtonTextMatcher("/"));
			ButtonOperator multiply = new ButtonOperator(shell, new ButtonTextMatcher("*"));
			
			ButtonOperator equals = new ButtonOperator(shell, new ButtonTextMatcher("="));
			
			perform(seven, plus, nine, equals);
			result.hasText(equalTo("16"));
			
			perform(two, three, minus, eight, equals);
			result.hasText(equalTo("15"));
			
			perform(one, five, divide, three, equals);
			result.hasText(equalTo("5"));
		} finally {
			shell.close();
		}
	}

	private EqualityMatcher<String> equalTo(String value) {
		return new EqualityMatcher<String>(value);
	}

	private void perform(ButtonOperator...sequence) {
		for (ButtonOperator each : sequence) {
			each.click();
		}
	}

}
