package org.exhibitj.operators;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.exhibitj.defect.Defect;
import org.exhibitj.operators.matchers.ButtonTextMatcher;
import org.junit.Test;

public class TestButtonOperator extends AbstractControlOperator<Button, ButtonOperator> {
	private static final String BUTTON_TEXT = "hit me";
	
	@Test(timeout=5000)
	public void textVisibleToUser() throws Exception {
		ButtonOperator button = createOperator();
		
		button.hasText(equalTo(BUTTON_TEXT));
	}

	@SuppressWarnings("unchecked")
	@Override
	protected ButtonOperator createOperator() {
		SWTDisplayThread.syncExec(new Runnable() {
			@Override
			public void run() {
				control.setText(BUTTON_TEXT);
			}
		});
		return new ButtonOperator(shell, new ButtonTextMatcher(BUTTON_TEXT));
	}
	
	@Test(expected=Defect.class, timeout=5000)
	public void unexpectedTextOnLabel() throws Exception {
		ButtonOperator button = createOperator();
		button.hasText(equalTo("incorrect text"));
	}
	
	@Override
	protected Class<Button> widgetType() {
		return Button.class;
	}

	@Test
	public void userClicksMouseButton() throws Exception {
		final SelectionListener listener = mock(SelectionListener.class);
		
		ButtonOperator button = createOperator();
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				control.addSelectionListener(listener);
			}
		});
		button.click();
		
		verify(listener).widgetSelected(any(SelectionEvent.class));
	}
}
