package org.exhibitj.operators;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Combo;
import org.exhibitj.operators.matchers.NamedControlMatcher;
import org.junit.Test;

public class TestComboOperator extends AbstractControlOperator<Combo, ComboOperator> {
	private static final String UNIQUE_WIDGET_NAME = "myCombo";

	@Override
	protected Class<Combo> widgetType() {
		return Combo.class;
	}
	
	@Test
	public void userMakesSelection() throws Exception {
		ComboOperator operator = createOperator();
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				control.add("apple");
				control.add("banana");
				control.add("grape");
				control.add("orange");
				control.add("strawberry");
				control.add("cherry");
				control.add("kiwi");
				control.add("passion fruit");
				control.add("black berry");
				for (int i = 1; i < 21; i++) {
					control.add("filler " + i);
				}
				control.add("blue berry");
			}
		});
		operator.select("kiwi");
		operator.hasText(equalTo("kiwi"));
		
		operator.select("apple");
		operator.hasText(equalTo("apple"));
		
		operator.select("blue berry");
		operator.hasText(equalTo("blue berry"));
	}
	
	@Test
	public void selectionWhenSmallFontSizeIsUsed() throws Exception {
		ComboOperator operator = createOperator();
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				Font font = control.getFont();
				Font smallFont = new Font(font.getDevice(), "bobo", 6, SWT.ITALIC);
				control.setFont(smallFont);
				control.add("apple");
				control.add("banana");
				control.add("grape");
				control.add("orange");
				control.add("strawberry");
				control.add("cherry");
				control.add("kiwi");
				control.add("passion fruit");
				control.add("black berry");
				for (int i = 1; i < 21; i++) {
					control.add("filler " + i);
				}
				control.add("blue berry");
			}
		});
		operator.select("kiwi");
		operator.hasText(equalTo("kiwi"));
		
		operator.select("apple");
		operator.hasText(equalTo("apple"));
		
		operator.select("blue berry");
		operator.hasText(equalTo("blue berry"));
	}
	
	@Test
	public void userEntersText() throws InterruptedException {
		ComboOperator operator = createOperator();
		operator.click();
		operator.enterText("hello");
		operator.hasText(equalTo("hello"));
	}

	@SuppressWarnings("unchecked")
	@Override
	protected ComboOperator createOperator() {
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				control.setData(NamedControlMatcher.DEFAULT_NAME, UNIQUE_WIDGET_NAME);
			}
		});
		return new ComboOperator(shell, new NamedControlMatcher<Combo>(UNIQUE_WIDGET_NAME));
	}

	@Test(timeout=5000)
	public void textVisibleToUser() throws Exception {
		ComboOperator combo = createOperator();
		
		combo.hasText(equalTo(""));
	}

}
