package org.exhibitj.operators;

import org.eclipse.swt.widgets.Label;
import org.exhibitj.operators.matchers.NamedControlMatcher;
import org.junit.Test;


public class TestLabelOperator extends AbstractControlOperator<Label, LabelOperator>{
	private static final String UNIQUE_WIDGET_NAME = "myName";

	@Override
	protected Class<Label> widgetType() {
		return Label.class;
	}
	
	@Test
	public void userEntersText() {
		LabelOperator operator = createOperator();
		operator.click();
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				control.setText("hello");
			}
		});
		operator.hasText(equalTo("hello"));
	}

	@SuppressWarnings("unchecked")
	@Override
	protected LabelOperator createOperator() {
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				control.setData(NamedControlMatcher.DEFAULT_NAME, UNIQUE_WIDGET_NAME);
			}
		});
		return new LabelOperator(shell, new NamedControlMatcher<Label>(UNIQUE_WIDGET_NAME));
	}

	@Test(timeout=5000)
	public void textVisibleToUser() throws Exception {
		LabelOperator text = createOperator();
		
		text.hasText(equalTo(""));
	}

}
