package org.exhibitj.operators;

import junit.framework.Assert;

import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestShellOperator {
	
	private ShellOperator shell;

	@Before
	public void setUp() {
		shell = createShellOperator();
	}
	
	@Test
	public void openShell() throws Exception {
		Assert.assertFalse(shell.isVisible());
		shell.open();
		Assert.assertTrue(shell.isVisible());
		Assert.assertFalse(shell.isDisposed());
		shell.close();
	}
	
	@Test
	public void closeShell() throws Exception {
		shell.open();
		shell.close();
		Assert.assertFalse(shell.isVisible());
		Assert.assertTrue(shell.isDisposed());
	}
	
	@After
	public void tearDown() {
		if (!shell.isDisposed()) {
			shell.close();
		}
		shell = null;
	}
	
	private ShellOperator createShellOperator() {
		ShellOperator shellOperator = new ShellOperator(new UIBuilder() {
			@Override
			public void create(Shell shell) {
				shell.setLocation(200, 200);
				shell.setSize(100, 100);
			}
		});
		return shellOperator;
	}
}
