import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Timer;
import java.util.TimerTask;

import org.jdom2.JDOMException;


/**
 * Main Class for executing the FIOS ETL Process
 * The Corresponding Settings are stored in Textfiles. within the same folder of this jar file
 * @author Tobias Weller, AIFB
 *
 */
public class ExeMain {

	
	public static void main(String[] args) {
		//This task will be executed everyday, which consists to 86.400 seconds
	//	TimerTask action = new TimerTask() {
	//		public void run() {
				try {	
					long total = System.currentTimeMillis();  
					String path = getPath();
					long start = System.currentTimeMillis();  
					//Run LDSpider
					System.out.println("Running ldSpider...");
					runldSpider ldSpider = new runldSpider();
					ldSpider.run(path);
					long ende = System.currentTimeMillis();
					double resul = ende - start;
					System.out.println("Zeit bentigt fr ldSpider: " + (resul/1000) + " sec"); 
					
					
					//Reasoner
					start = System.currentTimeMillis(); 
					System.out.println("Reasoning Step...");
					Reasoner res = new Reasoner(path);
					if (res.runReasoner()) {
						res.reason(path + "upload/rdfData.txt");
					}
					ende = System.currentTimeMillis();  
					resul = ende - start;
					System.out.println("Zeit bentigt fr Reasoning: " + (resul/1000) + " sec");
					
					
					//Normalizer
					start = System.currentTimeMillis(); 
					System.out.println("Normalizing Data...");
					Normalizer c = new Normalizer(path);
					if (c.runNormalizer()) {
						c.run(path + "upload/rdfData.txt");
					}
					
					ende = System.currentTimeMillis();  
					resul = ende - start;
					System.out.println("Zeit bentigt fr Normalizing: " + (resul/1000) + " sec");
					
					
					//Upload Data
					System.out.println("Uploading Data...");
					Uploader up = new Uploader();
					up.getData(path);
					
					//Ende
					resul = (System.currentTimeMillis() - total)/60000;
					System.out.println("Zeit bentigt fr gesamten Prozess: " + resul + " min");
					
					//Queries ausfhren:
					BufferedReader file = new BufferedReader (new FileReader(path + "Settings_Uploader.txt"));
					String[] zeile = file.readLine().split("@");
					file.close();
					String uri = "INSERT INTO GRAPH <" + zeile[3] + "> {?ds <http://purl.org/linked-data/cube#structure> <http://" + zeile[0] + ":8080/fios#secyhofdsd>.} from <" + zeile[3] + ">+where+{+%3Fds+<http%3A%2F%2Fpurl.org/linked-data/cube%23structure>+%3Fdsd.+}";
					uri = uri.replace(":", "%3A");
					uri = uri.replace("/", "%2F");
					uri = uri.replace(" ", "+");
					uri = uri.replace("?", "%3F");
					uri = uri.replace("#", "%23");
					uri = uri.replace("{", "%7B");
					uri = uri.replace("}", "%7D");
					String graph = zeile[3];
					graph = graph.replace(":", "%3A");
					graph = graph.replace("/", "%2F");
					graph = graph.replace(" ", "+");
					graph = graph.replace("?", "%3F");
					graph = graph + "%3Asaiku&should-sponge=";
					URL url = new URL("http://" + zeile[0] + ":8890/sparql?default-graph-uri=" + graph + "&query=" + uri); 

			        URLConnection connection = url.openConnection(); 	 

			        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
					
				} catch (URISyntaxException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (JDOMException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} 
		//	} 
	//	};
	//	Timer caretaker = new Timer();
	//	caretaker.schedule(action, 500, 86400000);
	}

	/**
	 * This methods returns a String of the path, where the Jar File is running
	 * 
	 * @return Path of the Jar File, where its running
	 * @throws URISyntaxException
	 */
	private static String getPath() throws URISyntaxException {
		CodeSource codeSource = Uploader.class.getProtectionDomain().getCodeSource();
		File jarFile = new File(codeSource.getLocation().toURI().getPath());
		String jarDir = jarFile.getParentFile().getPath() + "/";
	    return jarDir;
	}

}
