import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;

/**
 * Normalizes the Triples, corresponding to the Settings in the two TextFiles.
 * One Textfiles contains the new BaseURI, the other the URIs that should be changed.
 * 
 * @author Tobias Weller, AIFB
 *
 */
public class Normalizer {
	HashSet<String> hs;
	String baseURI;

	/**
	 * Consutrctor Method.
	 * 
	 * Reads the two Textfiles with the corresponding settings.
	 * 
	 * @param fileArchive String of the path, where the file is running.
	 */
	public Normalizer(String fileArchive) {
		this.hs = new HashSet<String>();
		try {
			String zeile = "";
			BufferedReader file2 = new BufferedReader (new FileReader(fileArchive + "Settings_Normalizer.txt"));
			while ((zeile = file2.readLine()) != null) {
				this.hs.add(zeile);		
			}
			
			file2 = new BufferedReader (new FileReader(fileArchive + "Settings_BaseURI.txt"));
			while ((zeile = file2.readLine()) != null) {
				if (zeile.endsWith("/")) {
					this.baseURI = zeile;
				} else {
					this.baseURI = zeile + "/";
				}
				
			}
			file2.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public Normalizer() {
		this.hs = new HashSet<String>();
		this.hs.add("Yahoo");
		this.hs.add("Edgar");
		this.hs.add("dbPedia");
		this.hs.add("CompanyMetaWrap");
		this.hs.add("lycos");
		this.baseURI = "http://fios.b-kaempgen.de/";
	}
	
	/**
	 * Returns false if there is no BaseURI maintained
	 * @return
	 */
	public boolean runNormalizer() {
		if (this.baseURI == null) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	 * Method for normalizing the Triples.
	 * 
	 * @param path Path where the file is running.
	 */
	public void run(String path) {
		if (!this.baseURI.equalsIgnoreCase("")) {
			try {
				String zeile = "";
				File f2 = copyfile(path, "data_Reason");
				BufferedReader file = new BufferedReader (new FileReader(f2.getAbsoluteFile()));
				
				FileWriter writer = new FileWriter(new File(path), false);
				while ((zeile = file.readLine()) != null) {
					if (zeile.trim().equalsIgnoreCase(".")) {
						
					} else {
						String[] str = zeile.split(" ");
						
						int i = 0;
						if (zeile.contains("> <http://www.w3.org/2002/07/owl#sameAs> <")) {
							String[] oldChar = checkReplace(str[0]);
							if (oldChar[1] != null) {
								str[0] = str[i].replace(oldChar[0], this.baseURI + oldChar[1] + "/");
								writer.write(str[0] + " <http://www.w3.org/2002/07/owl#sameAs> " + str[2]);
							} else {
								writer.write(str[0] + " <http://www.w3.org/2002/07/owl#sameAs> " + str[2]);
							}
						} else {
							while (i < str.length - 2) {
								if (i < 3) {
									String[] oldChar = checkReplace(str[i]);
									if (oldChar[1] != null) {
										str[i] = str[i].replace(oldChar[0], this.baseURI + oldChar[1] + "/");
									}
								}						
								writer.write(str[i] + " ");
								
								i++;
							}
						}
						
						writer.write(" .");
						writer.write(System.getProperty("line.separator"));
					}	
						
				}
				file.close();
				writer.flush();
				writer.close();
				f2.delete();
			} catch (FileNotFoundException e) {
				System.out.println("Datei nicht gefunden");
			} catch (IOException e) {
				System.out.println("E/A-Fehler");
			}
		}
		
	}
	
	/**
	 * Checks if the String is within the normalized Triples.
	 * 
	 * @param check String that should be checked.
	 * @return Returns the String and the number, where the String is.
	 */
	private String[] checkReplace(String check) {
		Iterator<String> it = this.hs.iterator();
		boolean hit = false;
		String result[] = new String[2];
		int i = 0;
		while(it.hasNext() && !hit) {
			i++;
			result[0] = it.next();
			if (check.contains(result[0])) {
				hit = true;
				result[1] = String.valueOf(i);
			}
		}
		return result;
	}
	
	
	/**
	 * Copies a file into the new filename.
	 * 
	 * @param srFile Old File that should be copied.
	 * @param dtFile New File, which will be created with its name
	 * @return Returns the new File.
	 */
	private File copyfile(String srFile, String dtFile){
		File f2 = null;
		  try{
		  File f1 = new File(srFile);
		  f2 = File.createTempFile(dtFile, ".tmp");
		  InputStream in = new FileInputStream(f1);
		  
		  //For Append the file.
		//  OutputStream out = new FileOutputStream(f2,true);

		  //For Overwrite the file.
		  OutputStream out = new FileOutputStream(f2);

		  byte[] buf = new byte[1024];
		  int len;
		  while ((len = in.read(buf)) > 0){
		  out.write(buf, 0, len);
		  }
		  in.close();
		  out.close();
		  System.out.println("File copied.");
		  }
		  catch(FileNotFoundException ex){
		  System.out.println(ex.getMessage() + " in the specified directory.");
		  System.exit(0);
		  }
		  catch(IOException e){
		  System.out.println(e.getMessage());  
		  }
		  return f2;
		  }
}
