import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

/**
 * Reasoning Class for doing the reasoning
 * 
 * @author Tobias Weller, AIFB
 *
 */
public class Reasoner {
	
	boolean reasoner;

	/**
	 * Constructor Method
	 */
	public Reasoner(String fileArchive) {
		this.reasoner = false;
		String zeile = "";
		BufferedReader file;
		try {
			file = new BufferedReader (new FileReader(fileArchive + "Settings_Reasoner.txt"));
			while ((zeile = file.readLine()) != null) {
				if (zeile.equalsIgnoreCase("true")) {
					this.reasoner = true;
				} else {
					this.reasoner = false;
				}
			}
		} catch (FileNotFoundException e) {
			System.out.println("Settings_Reasoner.txt Datei nicht gefunden");
		} catch (IOException e) {
			System.out.println("E/A-Fehler");
		}
	}
	
	public Reasoner() {
		this.reasoner = true;
		String zeile = "";
	}
	
	public boolean runReasoner() {
		return this.reasoner;
	}
	
	/**
	 * Reasoning Method, which performs the reasoning step and solves the sameAs Statements
	 * @param fileArchive Path where the N3 File is.
	 * @throws IOException
	 */
	public void reason(String fileArchive) throws IOException {
		
		BufferedReader file = new BufferedReader (new FileReader(fileArchive));
		
		HashTable hashtable = new HashTable();
		int numTriples = 0;
		int numSameAs = 0;
		//SameAs Statements einlesen von file
		String zeile = "";
		while ((zeile = file.readLine()) != null) {
			numTriples++;
			if (zeile.contains("> <http://www.w3.org/2002/07/owl#sameAs> <") || zeile.contains("> <http://www.w3.org/2002/07/owl#equivalentProperty> <")) {
				numSameAs++;
				//splitte die sequence
				String[] splitt = zeile.split(" ");
				String key = splitt[0];
				String input = splitt[2];
				if (!key.equalsIgnoreCase(input)) {
					hashtable.insert(splitt[0], splitt[2]);
				}
			}
		}
		System.out.println("Anzahl Triples im Dokument: " + numTriples);
		System.out.println("Anzahl sameAs im Dokument: " + numSameAs);
		
		file.close();
		replaceReason(hashtable, fileArchive);
	}
	
	/**
	 * Replaces all Triples in the File of the path with the triples in the hashtable.
	 * @param hs Hashtable with the triples
	 * @param path Path of the jar file
	 */
	private static void replaceReason(HashTable hs, String path) {
		
		try {
			String zeile = "";
			File f2 = copyfile(path, "data_Reason");
		
			BufferedReader file = new BufferedReader (new FileReader(f2.getAbsoluteFile()));
			
			FileWriter writer = new FileWriter(new File(path), false);
			LinkedList<String> haveSameAs = new LinkedList();
			LinkedList<String> haveSameAsList = new LinkedList();
			LinkedList<String> haveEquivalent = new LinkedList();
			LinkedList<String> haveEquivalentList = new LinkedList();
			while ((zeile = file.readLine()) != null) {
				String[] str = zeile.split(" ");
				int i = 0;
				while (i < str.length) {
					if (i < 3) {
						//key ist die neue URI
						String key = hs.contains(str[i]);
						if (key != null) {
							str[i] = key;
						}
					}						
					writer.write(str[i] + " ");
					i++;
				}
				writer.write(System.getProperty("line.separator"));
				if (i < 5 && str[0] != null && !haveSameAs.contains(str[0])) {
					writer.write(str[0] + " <http://www.w3.org/2002/07/owl#sameAs> " + str[2] + " .");
					writer.write(System.getProperty("line.separator"));
					haveSameAs.add(str[0]);
				}
				if (str[0] != null && zeile.contains("> <http://www.w3.org/2002/07/owl#sameAs> <") && !haveSameAsList.contains(str[0])) {
					LinkedList<String> l = hs.getList(str[0]);
					
					int p = 0;
					if (l != null) {
						while (p < l.size()) {
							writer.write(str[0] + " <http://www.w3.org/2002/07/owl#sameAs> " + l.get(p) + " .");
							writer.write(System.getProperty("line.separator"));
							p++;
						}
					}
					i = 10;
					haveSameAsList.add(str[0]);
				}
				//EquivalentProperty
				if (i < 5 && str[0] != null && !haveEquivalent.contains(str[0])) {
					writer.write(str[0] + " <http://www.w3.org/2002/07/owl#equivalentProperty> " + str[2] + " .");
					writer.write(System.getProperty("line.separator"));
					haveEquivalent.add(str[0]);
				}
				if (str[0] != null && zeile.contains("> <http://www.w3.org/2002/07/owl#equivalentProperty> <") && !haveEquivalentList.contains(str[0])) {
					LinkedList<String> l = hs.getList(str[0]);
					
					int p = 0;
					if (l != null) {
						while (p < l.size()) {
							writer.write(str[0] + " <http://www.w3.org/2002/07/owl#equivalentProperty> " + l.get(p) + " .");
							writer.write(System.getProperty("line.separator"));
							p++;
						}
					}
					i = 10;
					haveEquivalentList.add(str[0]);
				}
			}
			file.close();
			writer.flush();
			writer.close();
			f2.delete();
			int[] stat = hs.statistic();
			System.out.println("Gre Hashmap: " + stat[1]);
			System.out.println("Verkleinert zu: " + stat[0]);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	
	/**
	 * Copies a file into the new filename.
	 * 
	 * @param srFile Old File that should be copied.
	 * @param dtFile New File, which will be created with its name
	 * @return Returns the new File.
	 */
	private static File copyfile(String srFile, String dtFile){
		File f2 = null;
		  try{
		  File f1 = new File(srFile);
		  f2 = File.createTempFile(dtFile, ".tmp");
		  InputStream in = new FileInputStream(f1);
		  
		  //For Append the file.
		//  OutputStream out = new FileOutputStream(f2,true);

		  //For Overwrite the file.
		  OutputStream out = new FileOutputStream(f2);

		  byte[] buf = new byte[1024];
		  int len;
		  while ((len = in.read(buf)) > 0){
		  out.write(buf, 0, len);
		  }
		  in.close();
		  out.close();
		  System.out.println("File copied.");
		  }
		  catch(FileNotFoundException ex){
		  System.out.println(ex.getMessage() + " in the specified directory.");
		  System.exit(0);
		  }
		  catch(IOException e){
		  System.out.println(e.getMessage());  
		  }
		  return f2;
		  }
}
