/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.logger.logGui.elements;

import fmsactionserver.server.logger.InputLogger;
import fmsactionserver.server.elements.SpecialInput;
import fmsactionserver.server.logger.logevent.InputEvent;
import fmsactionserver.server.logger.logevent.InputListener;
import fmsactionserver.server.settings.actions.data.InputType;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author rbs
 */
public class InputTable extends JPanel{

       DefaultTableModel dtm;
       
       InputLogger logger;
       InputType type;
               
    public InputTable(final InputType type, InputLogger logger) {
        setLayout(new BorderLayout());
        
        this.logger = logger;
        this.type = type;
        
        logger.addInputListener(new InputListener() {
            @Override
            public void onEvent(InputEvent event) {
                if (event.getInput().type == type)
                    addRow(event.getInput().getSpecialInput());
            }
        });
        
        String rowNames[];
        
        if (type == InputType.FMS)
            rowNames = new String[]{"Datum", "Zeit", "Melderkennung", "FMS-Text", "Status", "Aktion"};
        else
            rowNames = new String[]{"Datum", "Zeit", "RIC", "Funktion", "Text", "Aktion"};
        
        dtm = new DefaultTableModel(rowNames, 0);
        
        getLastInputs();
        
        JTable table = new JTable(dtm);
        
        if (type == InputType.POCSAG)
        {
            table.getColumnModel().getColumn(0).setMinWidth(70);
            table.getColumnModel().getColumn(1).setMinWidth(70);
            table.getColumnModel().getColumn(2).setMinWidth(70);
            table.getColumnModel().getColumn(3).setMinWidth(50);
            table.getColumnModel().getColumn(5).setMinWidth(80);

            table.getColumnModel().getColumn(0).setMaxWidth(70);
            table.getColumnModel().getColumn(1).setMaxWidth(70);
            table.getColumnModel().getColumn(2).setMaxWidth(70);
            table.getColumnModel().getColumn(3).setMaxWidth(50);
            table.getColumnModel().getColumn(5).setMaxWidth(80);
        }
        else
        {
            table.getColumnModel().getColumn(0).setMinWidth(70);
            table.getColumnModel().getColumn(1).setMinWidth(70);
            table.getColumnModel().getColumn(2).setMinWidth(80);
            table.getColumnModel().getColumn(4).setMinWidth(50);
            table.getColumnModel().getColumn(5).setMinWidth(80);

            table.getColumnModel().getColumn(0).setMaxWidth(70);
            table.getColumnModel().getColumn(1).setMaxWidth(70);
            table.getColumnModel().getColumn(2).setMaxWidth(80);
            table.getColumnModel().getColumn(4).setMaxWidth(50);
            table.getColumnModel().getColumn(5).setMaxWidth(80);
        }
        
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        
        add(new JScrollPane(table), BorderLayout.CENTER);
        
    }
    
    
    private void getLastInputs()
    {
        dtm.setRowCount(0);
        
        ArrayList<SpecialInput> fmsInputs;
        if (type == InputType.FMS)
            fmsInputs = logger.getFMSInputs();
        else
            fmsInputs = logger.getPOCSAGInputs();
                    
        for (SpecialInput input: fmsInputs)
        {
            addRow(input);
        }
    }
    
    private void addRow(SpecialInput input)
    {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(input.date);

        java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat("dd.MM.yyyy");
        java.text.SimpleDateFormat timeFormat = new java.text.SimpleDateFormat("HH:mm:ss");
        String date = dateFormat.format(input.date);
        String time = timeFormat.format(input.date);

        String rowData[] = {date, time, input.fms1, input.fms2, input.fms3, "" + input.actionState};
        dtm.addRow(rowData);
    }
    
}
