/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.settings.actions.elements;

import fmsactionserver.server.settings.actions.data.InputType;
import fmsactionserver.server.settings.actions.data.ActionSetting;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 *
 * @author rbs
 */
public class InputPanel extends JPanel{



    JLabel nameLabel, ricLabel, progLabel, soundLabel;
    JComboBox typeField;
    JTextField ricField, progField, soundField;
    JButton selProg, selSound;
    
    public InputPanel() {
        setLayout(new GridLayout(3, 4, 25, 10));
        
        setBorder(BorderFactory.createEmptyBorder(20, 30, 20, 30));
        
        nameLabel = new JLabel("Typ:");
        ricLabel = new JLabel("Ric:");
        progLabel = new JLabel("Aktion (opt.):");
        soundLabel = new JLabel("Sound (opt.):");
        
        String elements[] = {"FMS", "POCSAG"};
        typeField = new JComboBox(elements);
        ricField = new JTextField();
        progField = new JTextField();
        soundField = new JTextField();
        
        selProg = new JButton("Durchsuchen");
        
        selProg.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
                int result = fileChooser.showOpenDialog(null);
                if (result == JFileChooser.APPROVE_OPTION)
                    progField.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        
        
        selSound = new JButton("Durchsuchen");
        selSound.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
                fileChooser.setFileFilter(new javax.swing.filechooser.FileFilter() {

                    String description = "WAV Dateien (*.wav)";
                    //Dateiendung
                    String extension = "wav";
                    
                    @Override
                    public boolean accept(File file) {
                        if (file == null) {
                            return false;
                        }
                        //zeigt alle Ordner an
                        if (file.isDirectory()) {
                            return true;
                        }
                        //gibt nur Dateien mit .pdf Erweiterung aus
                        return file.getName().toLowerCase().endsWith(extension);
                    }

                    @Override
                    public String getDescription() {
                        return description;
                    }
                });
                
                int result = fileChooser.showOpenDialog(null);
                if (result == JFileChooser.APPROVE_OPTION)
                    soundField.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        
        //Zeile 1:
        add(nameLabel);
        add(ricLabel);
        add(progLabel);
        add(soundLabel);
        
        //Zeile 2:
        add(typeField);
        add(ricField);
        add(progField);
        add(soundField);
        
        //Zeile 3:
        add(new JPanel());
        add(new JPanel());
        add(selProg);
        add(selSound);
        
        
    }
    
    public ActionSetting getSettingfromInput() {
        if (typeField.getSelectedIndex() == 0)
            return new ActionSetting(InputType.FMS, ricField.getText(), progField.getText(), soundField.getText());
        else
            return new ActionSetting(InputType.POCSAG, ricField.getText(), progField.getText(), soundField.getText());
    }
}
