/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.settings.actions.elements;

import fmsactionserver.server.settings.actions.SettingsFrame;
import fmsactionserver.server.settings.actions.data.ActionSetting;
import fmsactionserver.server.settings.actions.data.ActionSettingsCollector;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

/**
 *
 * @author rbs
 */
public class MainControllPanel extends JPanel{


    public MainControllPanel(final String directory, final ActionTablePanel tablePanel, final InputPanel inputPanel, final SettingsFrame mainFrame, final ActionSettingsCollector settings) {
        setLayout(new GridLayout(1,5));
        setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

        final ActionSettingsCollector tempSettings = settings;
        
        JButton saveButton = new JButton("Speichern");
        saveButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setSettings(tempSettings.getSettings());
                try {
                    System.out.println("Saving under: " + directory + "settings");
                    File file = new File(directory + "settings");
                    if (!file.exists())
                        file.createNewFile();
                    
                    ObjectOutputStream outStream = new ObjectOutputStream(new FileOutputStream(file));
                    
                    outStream.writeObject(settings);
                } catch (IOException ex) {
                    Logger.getLogger(MainControllPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        
        JButton closeButton = new JButton("Schließen");
        closeButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                mainFrame.dispose();
            }
        });
        
        JButton addButton = new JButton("Hinzufügen");
        addButton.setForeground(Color.GREEN);
        addButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionSetting settingfromInput = inputPanel.getSettingfromInput();
                tempSettings.addSetting(settingfromInput);
                tablePanel.addRow(settingfromInput);
            }
        });
        
        JButton delButton = new JButton("Löschen");
        delButton.setForeground(Color.RED);
        delButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionSetting setting = tablePanel.getSettingFromSelectedRow();
                settings.removeSetting(setting);
                tablePanel.delSelectedRow();
            }
        });
        
        add(delButton);
        add(addButton);
        add(new JPanel());
        add(saveButton);
        add(closeButton);
    }


    
}
