/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.settings.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author rbs
 */
public class InputSettings implements Serializable{

    private String host;
    private InputSettingType type;

    
    public enum InputSettingType{
        FMS32, INET
    }
    
    public InputSettings(InputSettingType type) {
        this.type = type;
        this.host = "";
    }
    
    public InputSettings(InputSettingType type, String host) {
        this.type = type;
        this.host = host;
        
    }
    
    public void write2File()
    {
        ObjectOutputStream out = null;
        try {
            File file = new File("inputsettings");
            out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(this);
        } catch (IOException ex) {
            Logger.getLogger(InputSettings.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            try {
                out.close();
            } catch (IOException ex) {
                Logger.getLogger(InputSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
    
    public static InputSettings readFromFile()
    {
        ObjectInputStream inputStream = null;
        try {
            File file = new File("inputsettings");
            if (!file.exists())
                return null;
            inputStream = new ObjectInputStream(new FileInputStream(file));
            return (InputSettings) inputStream.readObject();
        } catch (Exception ex) {
            Logger.getLogger(InputSettings.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        } finally {
            try {
                inputStream.close();
            } catch (IOException ex) {
                Logger.getLogger(InputSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public InputSettingType getType() {
        return type;
    }
    
    public String getHost()
    {
        return host;
    }
}
