/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.settings.input;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

/**
 *
 * @author rbs
 */
public class InputSettingsFrame extends JFrame{

    private JPanel panel = new JPanel();
    private JRadioButton fmsServer = new JRadioButton("Daten von einem Rechner mit FMS32 (oder einem ähnlichem Programm) abrufen");
    private JRadioButton inetClient = new JRadioButton("Daten aus dem Internet abrufen");
    private ButtonGroup group = new ButtonGroup();
     
    private InputSettings settings;
    
    public InputSettingsFrame(InputSettings settings) {
    
                
        final JPanel ipPanel = new JPanel(new GridLayout(2, 1));
        ipPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
        final JLabel ipLabel = new JLabel("IP/Hostname:");
        final JTextField ipField = new JTextField();
        ipPanel.add(ipLabel);
        ipPanel.add(ipField);
        
        JButton closeButton = new JButton("OK");
        JButton cancelButton = new JButton("Abbrechen");
        
        cancelButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent ae) {
                close();
            }
        });
        
        closeButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent ae) {
                
                InputSettings settings;
                
                if(fmsServer.isSelected())
                {
                    settings = new InputSettings(InputSettings.InputSettingType.FMS32);
                    settings.write2File();
                    close();
                    
                }
                else if(inetClient.isSelected())
                {
                    if (ipField.getText().isEmpty())
                        JOptionPane.showMessageDialog(null, "Bitte einen Host angeben.", 
                            "Kein Host angegeben", JOptionPane.ERROR_MESSAGE);
                    else
                    {
                        settings = new InputSettings(InputSettings.InputSettingType.INET, ipField.getText());
                        settings.write2File();
                        close();
                    }
                        
                }
                else
                {
                    JOptionPane.showMessageDialog(null, "Bitte eine der Optionen wählen!", 
                            "Keine Option gewählt", JOptionPane.ERROR_MESSAGE);
                }
                    
            }
        });
        
        setMinimumSize(new Dimension(700, 170));
        setMaximumSize(new Dimension(700, 170));
    
        
        if (settings != null)
        {
            if (settings.getType() == InputSettings.InputSettingType.FMS32)
                fmsServer.setSelected(true);
            if (settings.getType() == InputSettings.InputSettingType.INET)
                inetClient.setSelected(true);
            if (!settings.getHost().isEmpty())
                ipField.setText(settings.getHost());
           
        }
        
        inetClient.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent ae) {
                ipLabel.setEnabled(true);
                ipField.setEnabled(true);
            }
        });
        
        fmsServer.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent ae) {
                ipLabel.setEnabled(false);
                ipField.setEnabled(false);
            }
        });
        
        group.add(inetClient);
        group.add(fmsServer);
        
        panel.setLayout(new GridBagLayout());
        
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.4;
        c.fill = 1;
        
        panel.add(fmsServer, c);
        
        c.gridx = 0;
        c.gridy = 1;
        panel.add(inetClient, c);
        
        c.gridx = 0;
        c.gridy = 2;
        panel.add(ipPanel, c);
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        
        buttonPanel.setLayout(new GridLayout(1, 2, 15, 10));
        buttonPanel.add(cancelButton);
        buttonPanel.add(closeButton);
        
        c.gridx = 0;
        c.gridy = 3;
        panel.add(buttonPanel, c);

        this.add(panel);
        
        setVisible(true);
    }
    
    private void close()
    {
        this.setVisible(false);
        this.dispose();
    }
    
    
}
