/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.shareserver;

import fmsactionserver.server.elements.SpecialInput;
import fmsactionserver.server.logger.InputLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author rbs
 */
public class SingleClientShareThread extends Thread{

    private Socket client;
    private final ShareCommand command;
    ArrayList<SpecialInput> fMSInputs;
    ArrayList<SpecialInput> pOCSAGInputs;
    
    public SingleClientShareThread(Socket client, ShareCommand command, InputLogger logger) {
        this.client = client;
        this.command = command;
        fMSInputs = logger.getFMSInputs();
        pOCSAGInputs = logger.getPOCSAGInputs();
    }

    @Override
    public void run() {
        
        PrintWriter writer = null;;
        try {
            writer = new PrintWriter(client.getOutputStream(), true);
        } catch (IOException ex) {
            Logger.getLogger(SingleClientShareThread.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        
        int fmsCount;
        int pocCount;
        switch(command.getType())
        {
            case GET_ALL:
                fmsCount = 0;
                writer.println("200 SENDING FMS DATA");
                for(SpecialInput input : fMSInputs)
                {
                    writer.println(input.date.getTime() + "#" + input.fms1 + "#"
                        + input.fms2 + "#" + input.fms3);
                    fmsCount++;
                }
                writer.println("200 END FMS DATA");
                writer.println("200 " + fmsCount + " records sended.");
                writer.println("200 SENDING POCSAG DATA");
                
                pocCount = 0;
                for(SpecialInput input : pOCSAGInputs)
                {
                    writer.println(input.date.getTime() + "#" + input.fms1 + "#"
                        + input.fms2 + "#" + input.fms3);
                    pocCount++;
                }
                writer.println("200 END POCSAG DATA");
                writer.println("200 " + pocCount + " records sended.");
                writer.println("200 CONNECTION CLOSE");
                System.out.println("" + (pocCount + fmsCount) + " records sended.");
                break;
            case GET_SINCE_DATE:
                fmsCount = 0;
                writer.println("200 SENDING FMS DATA");
                for(SpecialInput input : fMSInputs)
                {
                    if (input.date.compareTo(command.getDate()) >= 0)
                    {
                        writer.println(input.date.getTime() + "#" + input.fms1 + "#"
                            + input.fms2 + "#" + input.fms3);
                        fmsCount++;
                    }
                }
                writer.println("200 END FMS DATA");
                writer.println("200 " + fmsCount + " records sended.");
                writer.println("200 SENDING POCSAG DATA");
                
                pocCount = 0;
                for(SpecialInput input : pOCSAGInputs)
                {
                    if (input.date.compareTo(command.getDate()) >= 0)
                    {
                        writer.println(input.date.getTime() + "#" + input.fms1 + "#"
                            + input.fms2 + "#" + input.fms3);
                        pocCount++;
                    }
                }
                writer.println("200 END POCSAG DATA");
                writer.println("200 " + pocCount + " records sended.");
                writer.println("200 CONNECTION CLOSE");
                
                break;
        }
    }
    
    
}
