/**
 * AmbientTalk/2 Project
 * (c) Software Languages Lab, 2006 - 2009
 * Authors: Ambient Group at SOFT
 * 
 * The source code in this file is based on source code from Tyler Close's
 * Waterken server, Copyright 2008 Waterken Inc. Waterken's code is published
 * under the MIT license.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package edu.vub.at.trace;

import java.io.IOException;
import java.io.Serializable;

/**
 * A stack trace.
 */
public class Trace implements Serializable {
    static private final long serialVersionUID = 1L;
    
    /**
     * list of call sites
     */
    public final CallSite[] calls;

    /**
     * Constructs an instance.
     * @param calls {@link #calls}
     */
    public Trace(final CallSite[] calls) {
        this.calls = calls;
    }
    
    /**
     * { "calls" : [ {
     *      "name" : "foo()",
     *      "source" : "foo.at",
     *      "span" : [ [ lineNo ] ]
     *    } ]
     * }
     */
    public void toJSON(JSONWriter json) throws IOException {
    	JSONWriter.ObjectWriter trace = json.startObject();
    	JSONWriter.ArrayWriter cls = trace.startMember("calls").startArray();
    	for (int i = 0; i < calls.length; i++) {
			calls[i].toJSON(cls.startElement());
		}
    	cls.finish();
    	trace.finish();
    }
}
