import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


public class ProxyHandler implements InvocationHandler {

	Object obj;

	public ProxyHandler() {
		this.obj = null;
	}
	
	public ProxyHandler(Object obj) {
		this.obj = obj;
	}

	public Object invoke(Object proxy, Method m, Object[] args)throws Throwable {
		   if(Object.class  == m.getDeclaringClass()) {
		       String name = m.getName();
		       if("equals".equals(name)) {
		           return proxy == args[0];
		       } else if("hashCode".equals(name)) {
		           return System.identityHashCode(proxy);
		       } else if("toString".equals(name)) {
		           return proxy.getClass().getName() + "@" +
		               Integer.toHexString(System.identityHashCode(proxy)) +
		               ", with InvocationHandler " + this;
		       } else {
		           throw new IllegalStateException(String.valueOf(m));
		       }
		   }
		   return m.invoke(obj, args);
		}
	}