package gloodb.queries;

import gloodb.Identity;

import java.io.Serializable;

public class SimpleSerializable implements Serializable {
    private static final long serialVersionUID = 1L;
    @Identity
    final Serializable id;
    
    public SimpleSerializable(Serializable id) { 
        this.id = id;
    }
    
    public Serializable getId() {
        return id;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SimpleSerializable other = (SimpleSerializable) obj;
        if (id == null) {
            if (other.id != null)
                return false;
        } else if (!id.equals(other.id))
            return false;
        return true;
    }
}