/*
 * Copyright (c) Dino Octavian.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution, and is available at
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * Contributors:
 *      Dino Octavian - initial API and implementation
 */
package gloodb.impl;

import gloodb.GlooException;



/**
 * Exception thrown when trying to commit or rollback a non-existent transaction.
 */
public class NoTransactionException extends GlooException {
	private static final long serialVersionUID = -6415367722914267397L;

	/**
     * Creates an exception with an associated message.
     * @param message The exception message.
     */
    public NoTransactionException(String message) {
        super(message);
    }
}
