package org.masterview.user.client.ui;

import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.GWT;
import org.masterview.user.client.data.PropertyMapper;
import org.masterview.user.client.data.DataSource;
import org.masterview.user.client.i18n.MasterviewResources;

import java.util.List;

public class GridRendererImpl implements GridRenderer {
    public static final String GRID_STYLE = "masterview-grid";
    public static final String GRID_HEADER_STYLE = "masterview-grid-header";
    public static final String GRID_ROW_HIGHLIGHT_STYLE = "masterview-grid-row-highlight";
    public static final String GRID_ROW_EVEN_STYLE = "masterview-grid-row-even";
    public static final String GRID_ROW_ODD_STYLE = "masterview-grid-row-odd";
    public static final String GRID_HEADER_CELL_STYLE = "masterview-grid-header-cell";
    public static final String GRID_ROW_CELL_STYLE = "masterview-grid-row-cell";
    public static final String GRID_CELL_ASCENDING_SORTING_STYLE = "masterview-grid-sorted-asc";
    public static final String GRID_CELL_DESCENDING_SORTING_STYLE = "masterview-grid-sorted-desc";
    private static final String GRID_FILTER_ROW_STYLE = "masterview-grid-filter";
    private static final String GRID_FILTER_TEXTBOX_STYLE = "masterview-grid-filter-textbox";

    protected DataSource dataSource;

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Grid grid;

    public Grid getGrid() {
        return grid;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    /*public int getFirstDataRowNumber() {
        return 1;
    }*/

    public String getGridStyle() {
        return GRID_STYLE;
    }

    public String getHeaderStyle() {
        return GRID_HEADER_STYLE;
    }

    public String getRowHighlightStyle() {
        return GRID_ROW_HIGHLIGHT_STYLE;
    }

    public String getRowStyle(int row) {
        if (row % 2 == 0) {
            return GRID_ROW_EVEN_STYLE;
        } else {
            return GRID_ROW_ODD_STYLE;
        }
    }

    public String getHeaderCellStyle() {
        return GRID_HEADER_CELL_STYLE;
    }

    public String getRowCellStyle() {
        return GRID_ROW_CELL_STYLE;
    }

    public String getCellAscendingSortingStyle() {
        return GRID_CELL_ASCENDING_SORTING_STYLE;
    }

    public String getCellDescendingSortingStyle() {
        return GRID_CELL_DESCENDING_SORTING_STYLE;
    }

    public void highlightRow(int rowNumber) {
        if (rowNumber >= grid.getFirstRowWithDataNumber()) {
            grid.getRowFormatter().setStyleName(rowNumber, getRowHighlightStyle());
        }
    }

    public void cancelRowHighlighting(int rowNumber) {
        if (rowNumber >= grid.getFirstRowWithDataNumber()) {
            grid.getRowFormatter().setStyleName(rowNumber, getRowStyle(rowNumber));
        }
    }

    public void renderHeader(List columns) {
        for (int i = 0; i < columns.size(); i++) {
            Column column = (Column) columns.get(i);

            getGrid().setText(0, i, column.getTitle());
            getGrid().getCellFormatter().setStyleName(0, i, GRID_HEADER_CELL_STYLE);

            if (!column.getWidth().equals("")) {
                getGrid().getCellFormatter().setWidth(0, i, column.getWidth());
            }
        }

        getGrid().getRowFormatter().setStyleName(0, getHeaderStyle());
    }

    public void renderFilters(List columns) {
        for (int i = 0; i < columns.size(); i++) {
            final Column column = (Column) columns.get(i);

            final TextBox filterTextBox = new TextBox();
            filterTextBox.setWidth("100%");
            filterTextBox.setText("Filter is not set...");
            filterTextBox.addFocusListener(new FocusListener() {
                public void onFocus(Widget widget) {
                    if (filterTextBox.getText().equals("Filter is not set...")) {
                        filterTextBox.setText("");
                    }
                }

                public void onLostFocus(Widget widget) {
                    if (filterTextBox.getText().matches("[*]*")) {
                        filterTextBox.setText("Filter is not set...");
                        grid.removeFilter(column);
                    } else {
                        grid.applyFilter(column, filterTextBox.getText());
                    }
                }
            });
            filterTextBox.setStyleName(getFilterTextBoxStyle());
            getGrid().setWidget(1, i, filterTextBox);
            /*getGrid().getCellFormatter().setStyleName(0, i, GRID_HEADER_CELL_STYLE);*/

            if (!column.getWidth().equals("")) {
                getGrid().getCellFormatter().setWidth(1, i, column.getWidth());
            }
        }

        getGrid().getRowFormatter().setStyleName(1, getFilterStyle());
    }

    private String getFilterTextBoxStyle() {
        return GRID_FILTER_TEXTBOX_STYLE;

    }

    public String getFilterStyle() {
        return GRID_FILTER_ROW_STYLE;
    }

    protected void renderEmptyBody(List columns) {
        MasterviewResources messages = (MasterviewResources)
                GWT.create(MasterviewResources.class);
        String noDataMessage = messages.noData();

        getGrid().setText(grid.getFirstRowWithDataNumber(), 0, noDataMessage);
        getGrid().getRowFormatter().setStyleName(grid.getFirstRowWithDataNumber(), getRowStyle(1));
        getGrid().getFlexCellFormatter().setColSpan(grid.getFirstRowWithDataNumber(), 0, columns.size());
    }

    public int renderItems(List columns, DataSource dataSource) {
        if (dataSource.isEmpty()) {
            renderEmptyBody(columns);
            return 1;
        }

        int itemsCount = dataSource.getDisplayData().size();
        int rowNumber = grid.getFirstRowWithDataNumber();

        for (int itemNumber = 0; itemNumber < itemsCount; itemNumber++) {
            Object item = dataSource.getDisplayData().get(itemNumber);

            for (int columnNumber = 0; columnNumber < columns.size(); columnNumber++) {
                Column column = (Column) columns.get(columnNumber);

                String cellText = dataSource.getPropertyMapper().getProperty(item, column.getPropertyName()).toString();
                getGrid().setText(rowNumber, columnNumber, cellText);
                getGrid().getCellFormatter().setStyleName(rowNumber, columnNumber, GRID_ROW_CELL_STYLE);

                if (!column.getWidth().equals("")) {
                    getGrid().getCellFormatter().setWidth(rowNumber, columnNumber, column.getWidth());
                }
            }

            getGrid().getRowFormatter().setStyleName(rowNumber, getRowStyle(rowNumber));
            rowNumber++;
        }

        return itemsCount;
    }
}