package org.masterview.user.client.ui;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Image;

/**
 * <p>This class represents basic button without text and with image.
 * It needs three images for states: normal, hovered and disabled.</p>
 *
 * @author TheSteam
 */
public class ImageButtonBase extends FocusWidget
{
    protected AbstractImagePrototype normalPrototype;
    protected AbstractImagePrototype hoverPrototype;
    protected AbstractImagePrototype disabledPrototype;
    protected Image image;

    public AbstractImagePrototype getDisabledPrototype() {
        return disabledPrototype;
    }

    public void setDisabledPrototype(AbstractImagePrototype disabledPrototype) {
        this.disabledPrototype = disabledPrototype;
    }

    public AbstractImagePrototype getHoverPrototype() {
        return hoverPrototype;
    }

    public void setHoverPrototype(AbstractImagePrototype hoverPrototype) {
        this.hoverPrototype = hoverPrototype;
    }

    public AbstractImagePrototype getNormalPrototype() {
        return normalPrototype;
    }

    public void setNormalPrototype(AbstractImagePrototype normalPrototype) {
        this.normalPrototype = normalPrototype;
    }

    public ImageButtonBase(AbstractImagePrototype normalPrototype,
                           AbstractImagePrototype hoverPrototype,
                           AbstractImagePrototype disabledPrototype) {
        super();

        this.normalPrototype = normalPrototype;
        this.hoverPrototype = hoverPrototype;
        this.disabledPrototype = disabledPrototype;

        image = getNormalPrototype().createImage();
        setElement(image.getElement());

        sinkEvents(Event.ONMOUSEOVER);
        sinkEvents(Event.ONMOUSEOUT);
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            getDisabledPrototype().applyTo(image);
        } else {
            getNormalPrototype().applyTo(image);
        }

        super.setEnabled(enabled);
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);

        if (!isEnabled()) {
            return;
        }

        switch (DOM.eventGetType(event)) {
            case Event.ONMOUSEOVER: {
                getHoverPrototype().applyTo(image);
                break;
            }
            case Event.ONMOUSEOUT: {
                getNormalPrototype().applyTo(image);
                break;
            }
            default: {
                // Do nothing
            }
        }
    }
}

