package org.masterview.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.*;
import com.google.gwt.user.client.Window;
import org.masterview.user.client.data.DataSourceListener;
import org.masterview.user.client.data.DataSourceImpl;
import org.masterview.user.client.data.DataSource;
import org.masterview.user.client.i18n.MasterviewResources;
import org.masterview.user.client.ui.bundle.MasterViewBundle;

public class Pager extends Composite implements ClickListener
{
    public static final String PAGER_STYLE = "masterview-pager";
    public static final String PAGER_STATUS_STYLE = "masterview-pager-status";
    public static final String PAGER_NAVIGATION_STYLE = "masterview-pager-navigation";

    protected Label pagerStatusLabel = new Label("");
    protected ListBox goToPageListBox = new ListBox();

    protected ImageButtonBase firstPageButton;
    protected ImageButtonBase previousPageButton;
    protected ImageButtonBase nextPageButton;
    protected ImageButtonBase lastPageButton;

    Grid grid;
    DataSource dataSource;

    protected SimplePanel header = new SimplePanel();
    protected DockPanel topBar = new DockPanel();
    protected VerticalPanel pageablePane = new VerticalPanel();

    public Pager(Grid grid, DataSource dataSource) {
        dataSource.addDataSourceListener(new DataSourceListener()
        {
            public void onDataChanged(int readItemsCount, int allItemsCount) {
                setStatus(readItemsCount, allItemsCount);
                setButtonsState();
            }
        });

        goToPageListBox.setVisibleItemCount(1);

        MasterViewBundle bundle = (MasterViewBundle) GWT.create(MasterViewBundle.class);
        firstPageButton = new ImageButtonBase(bundle.pageFirstNormal(),
                bundle.pageFirstHover(), bundle.pageFirstDisabled());
        firstPageButton.addClickListener(this);

        previousPageButton = new ImageButtonBase(bundle.pagePrevNormal(),
                bundle.pagePrevHover(), bundle.pagePrevDisabled());
        previousPageButton.addClickListener(this);

        nextPageButton = new ImageButtonBase(bundle.pageNextNormal(),
                bundle.pageNextHover(), bundle.pageNextDisabled());
        nextPageButton.addClickListener(this);

        lastPageButton = new ImageButtonBase(bundle.pageLastNormal(),
                bundle.pageLastHover(), bundle.pageLastDisabled());
        lastPageButton.addClickListener(this);

        this.dataSource = dataSource;

        this.grid = grid;
        this.grid.setDataSource(dataSource);
        grid.setWidth("100%");

        firstPageButton.setWidth("16px");
        previousPageButton.setWidth("16px");
        nextPageButton.setWidth("16px");
        lastPageButton.setWidth("16px");

        topBar.setHeight("100%");
        topBar.setWidth("100%");

        pagerStatusLabel.setStyleName(PAGER_STATUS_STYLE);
        pagerStatusLabel.setHeight("100%");

        header.setStylePrimaryName(PAGER_NAVIGATION_STYLE);
        header.setWidget(topBar);
        /*header.setHeight("21px");*/

        topBar.add(firstPageButton, DockPanel.WEST);
        topBar.add(previousPageButton, DockPanel.WEST);
        topBar.add(nextPageButton, DockPanel.WEST);
        topBar.add(lastPageButton, DockPanel.WEST);
        topBar.add(pagerStatusLabel, DockPanel.EAST);


        pageablePane.add(grid);
        pageablePane.add(header);

        pageablePane.setSpacing(0);
        pageablePane.setCellWidth(grid, "100%");
        pageablePane.setCellWidth(header, "100%");

        topBar.setCellWidth(firstPageButton, "16px");
        topBar.setCellWidth(previousPageButton, "16px");
        topBar.setCellWidth(nextPageButton, "16px");
        topBar.setCellWidth(lastPageButton, "16px");

        previousPageButton.setEnabled(false);
        firstPageButton.setEnabled(false);

        topBar.setCellVerticalAlignment(firstPageButton, VerticalPanel.ALIGN_MIDDLE);
        topBar.setCellVerticalAlignment(previousPageButton, VerticalPanel.ALIGN_MIDDLE);
        topBar.setCellVerticalAlignment(nextPageButton, VerticalPanel.ALIGN_MIDDLE);
        topBar.setCellVerticalAlignment(lastPageButton, VerticalPanel.ALIGN_MIDDLE);
        topBar.setCellVerticalAlignment(pagerStatusLabel, VerticalPanel.ALIGN_MIDDLE);

        pageablePane.setStyleName(PAGER_STYLE);

        setButtonsState();        

        initWidget(pageablePane);
    }

    public void onClick(Widget sender) {
        if (sender == nextPageButton) {
            dataSource.toNextPage();
        } else if (sender == previousPageButton) {
            dataSource.toPreviousPage();
        } else if (sender == firstPageButton) {
            dataSource.toFirstPage();
        } else if (sender == lastPageButton) {
            dataSource.toLastPage();
        }

        setButtonsState();
    }

    public void setButtonsState() {
        int pageCount = dataSource.getPageCount();
        int currentPageNumber = dataSource.getCurrentPageNumber();

        previousPageButton.setEnabled(true);
        nextPageButton.setEnabled(true);
        firstPageButton.setEnabled(true);
        lastPageButton.setEnabled(true);

        if (currentPageNumber == 0) {
            previousPageButton.setEnabled(false);
            firstPageButton.setEnabled(false);
        }

        if (currentPageNumber == (pageCount - 1)) {
            nextPageButton.setEnabled(false);
            lastPageButton.setEnabled(false);
        }
    }

    public void setStatus(int displayedItems, int allItems) {
        MasterviewResources messages = (MasterviewResources)
                GWT.create(MasterviewResources.class);
        pagerStatusLabel.setText(messages.status(String.valueOf(displayedItems),
                String.valueOf(allItems)));
    }
}
