package org.masterview.user.client.validation;

import junit.framework.TestCase;
import org.masterview.user.client.data.Filter;
import org.masterview.user.client.data.DataSourceImpl;
import org.masterview.user.client.data.DataSource;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DataSourceTest extends TestCase
{
    private DataSource dataSource;

    @Override
    protected void setUp() throws Exception {
        List items = new ArrayList();
        for (int i = 0; i < 100; i++) {
            items.add(new SampleBean(new Date(), i, "Object #" + i));
        }

        dataSource = new DataSourceImpl(items);
        dataSource.setPropertyMapper(new SampleBeanPropertyMapper());
    }

    public void testNextPage() {
        dataSource.setCurrentPageNumber(6);
        dataSource.toNextPage();
        assertEquals(dataSource.getCurrentPageNumber(), 7);
    }

    public void testPrevPage() {
        dataSource.setCurrentPageNumber(7);
        dataSource.toPreviousPage();
        assertEquals(dataSource.getCurrentPageNumber(), 6);
    }

    public void testLastPage() {
        dataSource.toLastPage();
        assertEquals(dataSource.getCurrentPageNumber(),
                dataSource.getInitialData().size() / dataSource.getPageSize());
    }

    public void testSetCurrentPageOverflow() {
        dataSource.setCurrentPageNumber(12);
        assertEquals(dataSource.getInitialData().size() / dataSource.getPageSize(),
                dataSource.getCurrentPageNumber());
    }

    public void testGetFilteredDataFirst() {
        dataSource.addFilter(new Filter("text", "Obje*1?"));
        dataSource.setPageSize(100);
        dataSource.refreshDisplayData();
        assertEquals(10, dataSource.getDisplayData().size());
    }

    public void testGetFilteredDataSecond() {
        dataSource.addFilter(new Filter("text", "Obje*1?"));
        dataSource.setPageSize(100);
        dataSource.refreshDisplayData();
        assertEquals(10, dataSource.getDisplayData().size());
    }

    public void testAdjustPage() {
        assertEquals(0, dataSource.getCurrentPageNumber());
        assertEquals(9, dataSource.getPageCount());

        dataSource.toLastPage();
        assertEquals(8, dataSource.getCurrentPageNumber());

        dataSource.addFilter(new Filter("number", "?1"));
        assertEquals(1, dataSource.getPageCount());
        assertEquals(0, dataSource.getCurrentPageNumber());
    }
}
