package org.masterview.user.client.validation;

import junit.framework.TestCase;
import org.masterview.user.client.ui.Column;
import org.masterview.user.client.data.PropertyMapper;
import org.masterview.user.client.data.DataSourceImpl;
import org.masterview.user.client.SortConstants;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DefaultGridSorterTest extends TestCase
{
    private DataSourceImpl dataSource;
    private PropertyMapper mapper;
    private Column column;

    @Override
    protected void setUp() throws Exception {
        List items = new ArrayList();
        for (int i = 0; i < 100; i++) {
            items.add(new SampleBean(new Date(), i, "Object #" + i));
        }

        dataSource = new DataSourceImpl(items);
        dataSource.setPropertyMapper(new SampleBeanPropertyMapper());
    }

    public void testSorting() {
        dataSource.setPageSize(100);

        SampleBean bean1;
        SampleBean bean2;

        bean1 = (SampleBean) dataSource.getInitialData().get(0);
        bean2 = (SampleBean) dataSource.getInitialData().get(1);
        assertTrue(bean1.getNumber() < bean2.getNumber());

        dataSource.setPropertyToSort("number");
        dataSource.setSortType(SortConstants.SORT_ASC);        

        bean1 = (SampleBean) dataSource.getDisplayData().get(0);
        bean2 = (SampleBean) dataSource.getDisplayData().get(1);
        assertTrue(bean1.getNumber() < bean2.getNumber());

        dataSource.setSortType(SortConstants.SORT_DESC);

        bean1 = (SampleBean) dataSource.getDisplayData().get(0);
        bean2 = (SampleBean) dataSource.getDisplayData().get(1);
        assertTrue(bean1.getNumber() > bean2.getNumber());
    }
}
